package gov.va.vinci.dart.usr;

import java.util.Collection;
import java.util.HashSet;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

/** Custom authenticator credentials holder for use with Spring Security
 *
 */
public class CustomAuthentication implements Authentication {

	private static final long serialVersionUID = 4410099468602019913L;
	
	private String name;
	private Collection<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
	private Object credentials;
	private Object details;
	private Object principal;
	private boolean authenticated = false;
	private UserPreferences userPreferences;
	 
	public CustomAuthentication(final String name, final Collection<GrantedAuthority> authorities, final Object credentials, final Object details, final Object principal) {
		this.name = name;
		if (authorities != null) {
			this.authorities.addAll(authorities);
		}
		this.credentials = credentials;
		this.details = details;
		this.principal = principal;
	}
	
	void grant(GrantedAuthority auth) {
		authorities.add(auth);
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public Collection<? extends GrantedAuthority> getAuthorities() {
		return authorities;
	}

	@Override
	public Object getCredentials() {
		return credentials;
	}

	@Override
	public Object getDetails() {
		return details;
	}

	@Override
	public Object getPrincipal() {
		return principal;
	}

	@Override
	public boolean isAuthenticated() {
		return authenticated;
	}

	public UserPreferences getUserPreferences() {
		return userPreferences;
	}

	public void setUserPreferences(UserPreferences userPreferences) {
		this.userPreferences = userPreferences;
	}

	@Override
	public void setAuthenticated(boolean isAuthenticated)
			throws IllegalArgumentException {
		this.authenticated = isAuthenticated;
	}
}
